//Source file: F:\jschwartz\src\Alkindi\BusinessDataTypes\RecommendationList.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/* 
$Header: RecommendationList.java, 9, 2/27/01 1:02:06 PM, Schwartz, Joe$
$Log: 
 9    Alkindi Development1.8         2/27/01 1:02:06 PM   Schwartz, Joe   Added
      clear() call.
 8    Alkindi Development1.7         12/28/00 1:06:54 PM  Schwartz, Joe   Added
      version control header info.
 7    Alkindi Development1.6         12/26/00 7:21:17 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/26/00 6:57:25 PM  Schwartz, Joe   
 5    Alkindi Development1.4         12/18/00 6:08:37 PM  Schwartz, Joe   
 4    Alkindi Development1.3         12/18/00 12:05:40 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 3    Alkindi Development1.2         10/19/00 1:12:17 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 2    Alkindi Development1.1         10/6/00 4:13:42 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:11:13 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * A list of Recommendation objects.
 */
public class RecommendationList implements Serializable 
{
	private ArrayList internalList;
	
	public RecommendationList() 
	{
		internalList = new ArrayList();
	}
	
	/**
	 * @roseuid 39D36A8B00AB
	 */
	public boolean add(Recommendation itemToAdd) 
	{
		return internalList.add(itemToAdd);
	}
	
	/**
	 * @roseuid 3A9AC81502BF
	 */
	public void clear() 
	{
		internalList.clear();
	}
	
	/**
	 * @roseuid 39D36A9102CE
	 */
	public Recommendation get(int idx) 
	{
		return (Recommendation) internalList.get(idx);
	}
	
	/**
	 * @roseuid 39D36A93000F
	 */
	public Iterator iterator() 
	{
		return internalList.iterator();
	}
	
	/**
	 * @roseuid 39D36A9402DE
	 */
	public RecommendationList(int numInit) 
	{
		internalList = new ArrayList(numInit);
	}
	
	/**
	 * @roseuid 39D36A960222
	 */
	public int size() 
	{
		return internalList.size();
	}
}
